/*:VRX         Main
*/
/*  Main
*/
/***************************************************/
/* Initialize REXXUtil environment (if not present)*/
/***************************************************/

rxload = RxFuncQuery('SysLoadFuncs')
If rxload then do
 call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
 call sysloadfuncs
end

/*
rxload = RxFuncQuery('SockLoadFuncs')
if rxload then do
 call RxFuncAdd 'SockLoadFuncs','RxSock','SockLoadFuncs'
 call SockLoadFuncs(1)
end
*/

/***************************************************/
/* Redirect Standerd IO                            */
/***************************************************/

ok = VRRedirectStdIO( Off, "" )

/***************************************************/
/* Main Process                                    */
/***************************************************/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end; else do
        call VROptions 'ImplicitNames'
        call VROptions 'NoEchoQuit'
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary:
    __vrlsWait = abbrev( 'WAIT', translate(arg(2)), 1 )
    if __vrlsWait then do
        call VRFlush
    end
    __vrlsHWnd = VRLoad( VRWindow(), VRWindowPath(), arg(1) )
    if __vrlsHWnd = '' then signal __vrlsDone
    if __vrlsWait \= 1 then signal __vrlsDone
    call VRSet __vrlsHWnd, 'WindowMode', 'Modal' 
    __vrlsTmp = __vrlsWindows.0
    if( DataType(__vrlsTmp) \= 'NUM' ) then do
        __vrlsTmp = 1
    end
    else do
        __vrlsTmp = __vrlsTmp + 1
    end
    __vrlsWindows.__vrlsTmp = VRWindow( __vrlsHWnd )
    __vrlsWindows.0 = __vrlsTmp
    do while( VRIsValidObject( VRWindow() ) = 1 )
        __vrlsEvent = VREvent()
        interpret __vrlsEvent
    end
    __vrlsTmp = __vrlsWindows.0
    __vrlsWindows.0 = __vrlsTmp - 1
    call VRWindow __vrlsWindows.__vrlsTmp 
    __vrlsHWnd = ''
__vrlsDone:
return __vrlsHWnd

/*:VRX         Fini
*/
Fini:
window = VRWindow()
call VRSet window, "Visible", 0
drop window
return 0

/*:VRX         Halt
*/
Halt:
/*
left = VRGet( window, "Left" )
top = VRGet( window, "Top" )
ok = VRSetIni( PROGRAM, "Left", left, IniFile, "NoClose" )
ok = VRSetIni( PROGRAM, "Top", top, IniFile )
*/
signal _VREHalt
return

/*:VRX         Init
*/
Init: procedure expose Globals.
Globals.WorkingDir = VRGet( "Application", "WorkingDirectory" )
Globals.IniFile = Globals.WorkingDir || "\WebManager.INI"
Globals.Program = "WebManager.EXE"
Globals.ScreenWidth = VRGet( 'Screen', 'Width' )
Globals.ScreenHeight = VRGet( 'Screen', 'Height' )
Globals.WindowLeft = VRGetIni( Globals.Program, "Left", Globals.IniFile, "NoClose" )
Globals.WindowTop = VRGetIni( Globals.Program, "Top", Globals.IniFile, "NoClose" )
Globals.WindowHeight = VRGetIni( Globals.Program, "Height", Globals.IniFile, "NoClose" )
Globals.WindowWidth = VRGetIni( Globals.Program, "Width", Globals.IniFile, "NoClose" )
window = VRWindow()
if( Globals.WindowLeft \= '' & Globals.WindowTop \= '' ) then do
 call VRSet window, 'Left', Globals.WindowLeft, 'Top', Globals.WindowTop
end; else do
 call VRMethod window, "CenterWindow"
end
if( Globals.WindowHeight \= '' & Globals.WindowWidth \= '' )then do
 call VRSet window, 'Height', Globals.WindowHeight, 'Width', Globals.WindowWidth
end
call VRSet window, "Visible", 1
call VRMethod window, "Activate"
drop window
return

/*:VRX         Quit
*/
Quit:
window = VRWindow()
call VRSet window, "Shutdown", 1
drop window
return

/*:VRX         Window1_Close
*/
Window1_Close:
call Quit
return

